const { default: chikaConnect, useMultiFileAuthState , DisconnectReason, fetchLatestBaileysVersion, generateForwardMessageContent, prepareWAMessageMedia, generateWAMessageFromContent, generateMessageID, downloadContentFromMessage, makeInMemoryStore, jidDecode, proto } = require("@adiwajshing/baileys")
const pino = require('pino')
const { Boom } = require('@hapi/boom')
const fs = require('fs')
const chalk = require('chalk')
require('dotenv/config')
const express = require('express')
const socket = require("socket.io");
const { toDataURL } = require('qrcode')
const mysql = require('mysql');
require('dotenv').config();
const request = require('request');
const { smsg } = require('./app_node/lib/myf')

const app = express()
const host = process.env.HOST ?? '127.0.0.1'
const port = parseInt(process.env.PORT ?? 3000)
app.use(express.urlencoded({ extended: true }))
app.use(express.json())
const ser = app.listen(port, host, () => {
    console.log(`Server is listening on http://${host}:${port}`)
})
const io = socket(ser);

const db = mysql.createPool({
    host: process.env.DB_HOSTNAME,
    user: process.env.DB_USERNAME,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_DATABASE
});

db.getConnection((err) => {
    if (err) throw err;
    console.log('Mysql Connected...');
});

const sessionMap = new Map()

async function startDEVICE(idevice) {
    const store = makeInMemoryStore({ logger: pino().child({ level: 'silent', stream: 'store' }) })
    // const { state, saveState } = useMultiFileAuthState(`./app_node/session/device-${idevice}.json`)
    const { state, saveCreds } = await useMultiFileAuthState(`./app_node/session/device-${idevice}.json`)
    const chika = chikaConnect({
        logger: pino({ level: 'silent' }),
        printQRInTerminal: true,
        browser: ['WAGEINDO', 'Safari', '1.0.0'],
        auth: state
    })
    store.bind(chika.ev)
    chika.decodeJid = (jid) => {
        if (!jid) return jid
        if (/:\d+@/gi.test(jid)) {
            let decode = jidDecode(jid) || {}
            return decode.user && decode.server && decode.user + '@' + decode.server || jid
        } else return jid
    }
    chika.ev.on('connection.update', async (update) => {
        const { connection, lastDisconnect, qr } = update
        if (connection === 'open') {
          
            // io.emit('message', {
            //     id: idevice,
            //     text: 'Whatsapp is ready!'
            // });
            // io.emit('authenticated', {
            //     id: idevice,
            //     data: chika.user
            // })
        }
        if (connection === 'close') {
            // sessionMap.delete(idevice)
            const logoutsessi = () => {
                chika.logout();
                if (fs.existsSync(`./sessions/${idevice}.json`)) {
                    fs.unlinkSync(`./sessions/${idevice}.json`);
                }
            }
            // let reason = new Boom(lastDisconnect?.error)?.output.statusCode
            let reason = lastDisconnect.error?.output?.statusCode;
            if (reason === DisconnectReason.badSession) { 
                console.log(`Bad Session File, Please Delete Session and Scan Again`); 
                logoutsessi(); 
            }else if (reason === DisconnectReason.connectionClosed) { 
                console.log("Connection closed, reconnecting...."); 
                startDEVICE(idevice); 
            }else if (reason === DisconnectReason.connectionLost) { 
                console.log("Connection Lost from Server, reconnecting..."); 
                startDEVICE(idevice); 
            }else if (reason === DisconnectReason.connectionReplaced) { 
                console.log("Connection Replaced, Another New Session Opened, Please Close Current Session First"); 
                logoutsessi(); 
            }else if (reason === DisconnectReason.loggedOut) { 
                console.log(`Device Logged Out, Please Scan Again And Run.`); 
                logoutsessi();
            }else if (reason === DisconnectReason.restartRequired) { 
                console.log("Restart Required, Restarting..."); 
                startDEVICE(idevice); 
            }else if (reason === DisconnectReason.timedOut) { 
                console.log("Connection TimedOut, Reconnecting..."); 
                startDEVICE(idevice); 
            }else 
                chika.end(`Unknown DisconnectReason: ${reason}|${connection}`)
            
        }
  
        if (update.qr) {
            //const url = await toDataURL(qr)
            if (res && !res.headersSent) {
              try {
                  // const qr = await toDataURL(update.qr)
  
                  // log = {"result": true, "instance": idevice, "qrcode": qr, "message": "Ready scan now!"}
                  // res.send(log);
                  // console.log(log)
                  // return
              } catch {
                  //response(res, 500, false, 'Unable to create QR code.')
              }
            }      
        }
        console.log(update)
    })
   
   return chika
}

const logoutDEVICE = (idevice) => {
    const chi = sessionMap.get(idevice)
    chi.chika.logout();
    if (fs.existsSync(`./app_node/session/device-${idevice}.json`)) {
        fs.unlinkSync(`./app_node/session/device-${idevice}.json`);
    }
    sessionMap.delete(idevice)
}

io.on('connection', function (socket) {
    socket.on('create-session', function (data) {
        if (sessionMap.has(parseInt(data.id))) {
            console.log('get session: ' + data.id);
            const conn = sessionMap.get(parseInt(data.id)).chika
            io.emit('message', {
                id: data.id,
                text: 'Whatsapp is ready!'
            });
            io.emit('authenticated', {
                id: data.id,
                data: conn.user
            })
        } else {
            console.log('Create session: ' + data.id);
            startDEVICE(data.id);
        }
    });
    socket.on('logout', async function (data) {
        if (fs.existsSync(`./app_node/session/device-${data.id}.json`)) {
            socket.emit('isdelete', {
                id: data.id,
                text: '<h2 class="text-center text-info mt-4">Logout Success, Lets Scan Again<h2>'
            })
            logoutDEVICE(data.id)
        } else {
            socket.emit('isdelete', {
                id: data.id,
                text: '<h2 class="text-center text-danger mt-4">You are have not Login yet!<h2>'
            })
        }
    })
});
s
require('./app_node/routes/web')(app, sessionMap, startDEVICE)
require('./app_node/lib/cron')(db, sessionMap, fs, startDEVICE)

// let file = require.resolve(__filename)
// fs.watchFile(file, () => {
//     fs.unwatchFile(file)
//     console.log(chalk.redBright(`Update ${__filename}`))
//     delete require.cache[file]
//     require(file)
// })
// process.on('uncaughtException', function (err) {
//   console.log('Caught exception: ', err);
// })

